function gMap(def_lng, def_lat, def_zoom, profile_url, marker_url)
{
	var map = new GMap(document.getElementById("map"));
	map.addControl(new GLargeMapControl());
	map.addControl(new GMapTypeControl());
	map.centerAndZoom(new GPoint(def_lng, def_lat), def_zoom);
	function createMarker(point, marker) {
		var id = marker.getAttribute("id");
		var username = marker.getAttribute("username");
		var title = marker.getAttribute("title");
		var url = marker.getAttribute("url");
		var location = marker.getAttribute("location");
		var avatar = '';
		if(marker.getAttribute("useavatar") == 1 && marker.getAttribute("avatar") != "")
		{
			avatar = "<dd><img src=\""+marker.getAttribute("avatar")+"\" alt=\"\" /></dd>";
		}
		else {
			avatar = '';
		}
		var marker_point = new GMarker(point);

		username = username.replace("<", "&lt;");
		username = username.replace(">", "&gt;");
		username = username.replace('"', "&quot;");

		location = location.replace("<", "&lt;");
		location = location.replace(">", "&gt;");
		location = location.replace('"', "&quot;");
		var html = "<dl><dt><strong><a href="+profile_url+""+id+">"+username+"</a></strong><br/><hr/>"+avatar+"<br/>"+location+"<br/>"+title+"<br/><a href=\""+url+"\">"+url+"</a><br/>"+avatar+"</dt></dl>";
		GEvent.addListener(marker_point, "click", function() {
			marker_point.openInfoWindowHtml(html);
		});

		return marker_point;
	}
	var request = GXmlHttp.create();
	request.open("GET", marker_url, true);
	request.onreadystatechange = function() {
		if (request.readyState == 4) {
			var xmlDoc = request.responseXML;
			var markers = xmlDoc.documentElement.getElementsByTagName("marker");
			for (var i = 0; i < markers.length; i++) {
				var point = new GPoint(parseFloat(markers[i].getAttribute("lng")), parseFloat(markers[i].getAttribute("lat")));
				if (!isNaN(point.x) && !isNaN(point.y)) {
					var marker_point = createMarker(point, markers[i])
					map.addOverlay(marker_point);
				}
			}
		}
	}
	request.send(null);
}